% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics


%%% Program IsoLuminantGrating
function IsoLuminantGrating (L_M_contrast)
if nargin < 1 || isempty(L_M_contrast), ...
      L_M_contrast = 0.2; end 
stimSize = 256;    % pixels
sf = 2;            % cycles/image
dkl = zeros(stimSize, 1, 3);
dkl(:, 1, 2) = sin(2*pi*sf* (1 : stimSize)/stimSize)/2;
dkl(:, 1, 2) = dkl(:, 1, 2) * L_M_contrast;
img = dkl; % pre-allocate
for i = 1 : stimSize
    img(i, 1, :) = DKL2RGB(squeeze(dkl(i, 1, :)));    
        % B = SQUEEZE(A) returns an array B with the same 
        % elements as A but with all the singleton 
        % dimensions removed.  A singleton is a dimension 
        % such that size(A,dim)==1.
end
img = repmat(img, [1 stimSize 1]);
[~, background] = DKL2RGB([0 0 0]');
    
imshow(img);
set(gcf, 'color', background);

